
### **What is Cryptography?**

- The study of information hiding and verification.
- Focuses on protocols, algorithms, and strategies to:
    - Prevent or delay unauthorized access to sensitive information.
    - Ensure verifiability of communication components.

---

### **Key Cryptographic Services**

Cryptography provides critical security services, often summarized as **CIA** (Confidentiality, Integrity, Authentication), along with additional capabilities:

1. **Confidentiality**:
    
    - Ensures that only authorized entities can read sensitive data.
    - Achieved through encryption techniques.
2. **Integrity**:
    
    - Verifies that data has not been altered during transit.
    - Uses hash functions or HMAC for integrity checks.
3. **Authentication**:
    
    - Confirms the identity of peers (users, devices, or systems).
    - Can be achieved through digital signatures or HMAC.
4. **Nonrepudiation**:
    
    - Ensures that the sender cannot deny sending the message.
    - Achieved using digital signatures.
5. **Key Management**:
    
    - Handles the generation, exchange, storage, and safeguarding of cryptographic keys.

---

### **Cryptographic Algorithms**

Cryptographic algorithms fall into three main categories:

#### **1. Symmetric Key Algorithms**

- Use the same key for encryption and decryption.
- Common examples: **AES**, **3DES**.
- Features:
    - Efficient and fast.
    - Typically used for encrypting large volumes of data.
    - Key lengths: 40-256 bits (e.g., AES-256 for high-security scenarios).

#### **2. Asymmetric/Public Key Algorithms**

- Use a key pair: **private key** (kept secret) and **public key** (shared).
- Common examples: **RSA**, **DSA**, **Elliptic Curve Cryptography (ECC)**.
- Features:
    - Enables secure key exchange (e.g., Diffie-Hellman).
    - Slower than symmetric algorithms.
    - Key lengths: 1024-4096 bits (ECC achieves similar security with smaller keys).

#### **3. Hash Algorithms**

- Irreversible algorithms that generate a fixed-length digest for any input.
- Common examples: **SHA-1**, **SHA-2** (SHA-256, SHA-384, SHA-512).
- Features:
    - Provide integrity by detecting any alteration in the data.
    - HMAC combines a hash function with a secret key for enhanced integrity.

---

### **Applications of Cryptographic Algorithms**

- **Symmetric Algorithms**:
    
    - Used for encrypting data to provide confidentiality.
    - Examples: IPsec and TLS encrypt data payloads.
- **Asymmetric Algorithms**:
    
    - Primarily used for key exchange, authentication, and digital signatures.
    - Example: Diffie-Hellman generates shared secret keys for symmetric encryption.
- **Hash Algorithms**:
    
    - Used for data integrity verification.
    - Example: HMAC enhances integrity using a secret key.

---

### **Core Cryptographic Concepts**

#### **Confidentiality**:

- Achieved through encryption (plaintext → ciphertext).
- Protocols:
    - **IPsec**: Encrypts IP packets for secure communication over untrusted networks.
    - **TLS/SSL**: Secures application-layer communication (e.g., HTTPS).

#### **Integrity**:

- Ensures data has not been modified during transit.
- Methods:
    - **Hashing**: Produces a fixed-length digest from data.
    - **HMAC**: Combines hashing with a secret key for enhanced integrity.

#### **Authentication**:

- Confirms the identity of the sender or data source.
- Methods:
    - **HMAC**: Ensures authentication for high-performance systems.
    - **Digital Signatures**:
        - Based on asymmetric cryptography.
        - Verifies data authenticity and provides nonrepudiation.

#### **Nonrepudiation**:

- Prevents the sender from denying the origin of a message.
- Achieved using **digital signatures**, as the private key used to sign the data is unique to the sender.

---

### **Symmetric vs. Asymmetric Encryption**

|**Feature**|**Symmetric Encryption**|**Asymmetric Encryption**|
|---|---|---|
|**Key Usage**|Single key (shared between parties)|Public-private key pair|
|**Speed**|Fast, suitable for large data volumes|Slower, used for small data and key exchange|
|**Examples**|AES, 3DES|RSA, ECC, Diffie-Hellman|
|**Key Length**|40-256 bits|1024-4096 bits|
|**Best Use Case**|Data encryption|Authentication, key exchange|

---

### **Integrity Mechanisms**

- **Hashing**:
    
    - Generates a unique "fingerprint" for data.
    - Examples: SHA-256, SHA-512.
- **HMAC**:
    
    - Combines a hash function with a secret key.
    - Used in IPsec for packet integrity.
- **Digital Signatures**:
    
    - Based on asymmetric cryptography.
    - Provides both integrity and nonrepudiation.

---

### **Authentication Mechanisms**

1. **Subject Authentication**:
    
    - Ensures the identity of users, devices, or systems.
    - Example: Challenge-response protocols using HMAC.
2. **Data Authentication**:
    
    - Confirms the source and authenticity of transmitted data.
    - Example: HMAC or digital signatures.

---

### **Nonrepudiation**

- **Digital Signatures**:
    - Provide proof of message origin.
    - Use private keys to sign data and public keys to verify signatures.
    - Unlike HMAC, digital signatures do not rely on shared secrets, enabling independent verification.

---

### **Cipher Suites**

- A combination of cryptographic algorithms used together to provide:
    - **Confidentiality**: Encrypting data with symmetric algorithms.
    - **Integrity**: Ensuring data is unaltered using hashing or HMAC.
    - **Authentication**: Verifying identity with asymmetric algorithms or digital signatures.

---

### **Key Takeaways**

- Cryptography combines **symmetric**, **asymmetric**, and **hash** algorithms to secure communication.
- Symmetric encryption is fast and suited for large data, while asymmetric encryption is slower but ideal for authentication and key exchange.
- Integrity mechanisms like HMAC and digital signatures ensure data authenticity and prevent tampering.
- Nonrepudiation is uniquely addressed by digital signatures, proving message origin.